---@alias EntityKind
---| "Nil"
---| "Boolean"
---| "Number"
---| "String"
---| "Table"
---| "Function"
---| "Error"
---| "Void"

---@class Entity
---@field __type "Entity"
---@field kind EntityKind
---@field value any
local Entity = {}
Entity.__index = Entity
Entity.__type = "Entity"
---cria uma nova entidade
---@param kind EntityKind
---@param value any
function Entity.new(kind, value)
    return setmetatable({
        kind = kind,
        value = value
    }, Entity)
end
---checagem de um unico tipo
---@param kind EntityKind
function Entity:check(kind)
    return self.kind == kind
end
---checagem de varios tipo
---@param ... EntityKind
function Entity:checkAnyKind(...)
    for _, kind in ipairs({...}) do
        if self.kind == kind then
            return true
        end
    end
    return false
end
---isso é para formatar a entidade como dado
function Entity:format()
    local kind = self.kind
    if kind == "Nil" then
        return "nil"
    elseif kind == "Boolean" then
        return self.value and "true" or "false"
    elseif kind == "Number" then
        return tostring(self.value)
    elseif kind == "String" then
        return self.value
    elseif kind == "Table" then
        local content, first = "", true
        for _, element in ipairs(self.value) do
            if not first then
                content = content .. ", "
            end
            content = content .. element:format()
            first = false
        end

        return "{" .. content .. "}"
    elseif kind == "Function" then
        return "function(" .. table.concat(self.value.parameters, " ") .. "){}"
    end
end
return Entity